.TH mmroff @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
mmroff \- cross-referencing front end for GNU
.I roff mm
macro package
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright 1989-2025 Free Software Foundation, Inc.
.\"
.\" This file is part of mm, a reimplementation of the Documenter's
.\" Workbench (DWB) troff memorandum macro package for use with GNU
.\" troff.
.\"
.\" mm is distributed with groff, the GNU roff typesetting system.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_mmroff_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY mmroff
.RB [ \-x ]
.IR groff-argument \~.\|.\|.
.YS
.
.
.P
.SY mmroff
.B \-\-help
.YS
.
.
.P
.SY mmroff
.B \%\-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I mmroff
is a simple wrapper for
.IR groff ,
used to expand cross references in
.I m@TMAC_M_PREFIX@m
documents;
see
.MR groff_mm @MAN7EXT@ .
.
It runs
.I groff
with the
.B \-mm
option twice,
first with
.B \-z
and
.B \-rRef=1
to populate cross-reference and index files with their corresponding
entries,
and then without to produce the document.
.
It also handles the inclusion of PostScript images with the
.B PIC
macro.
.
Documents that do not use these features of
.I "groff mm"
(the
.BR INITI ,
.BR IND ,
.BR INDP ,
.BR INITR ,
.BR SETR ,
.BR GETHN ,
.BR GETPN ,
.BR GETR ,
.BR GETST ,
and
.B PIC
macros)
do not require
.IR \%mmroff .
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays
a usage message,
while
.B \%\-\-version
shows version information;
both exit afterward.
.
.
.TP
.B \-x
Create or update the cross-reference file and exit.
.
.
.\" ====================================================================
.SH Environment
.\" ====================================================================
.
Normally,
the path separator in environment variables ending with
.I PATH
is the colon;
this may vary depending on the operating system.
.
For example,
Windows uses a semicolon instead.
.
.
.TP
.I GROFF_BIN_PATH
Locate
.I groff \" system
commands
in these directories,
followed by those in
.IR PATH .
.
If not set,
the installation directory of GNU
.I roff
executables,
.IR @BINDIR@ ,
is searched before
.IR PATH .
.
.
.\" ====================================================================
.SH "Exit status"
.\" ====================================================================
.
.I mmroff
exits with status
.B 0
if the
.B \-\-help
or
.B \%\-\-version
options were specified,
or if
.B \-x
was specified and the program successfully
created or updated the cross-reference file.
.
It exits with status
.B 1
if it was unable to create necessary files.
.
Otherwise,
it exits with the status of
.IR groff .
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
.I mmroff
was written by
.MT jh@\:axis\:.se
J\[o ad]rgen H\[a ad]gg
.ME
of Lund,
Sweden.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.MR groff_mm @MAN7EXT@ ,
.MR groff_mmse @MAN7EXT@ ,
.MR groff @MAN1EXT@ ,
.MR @g@troff @MAN1EXT@ ,
.MR @g@tbl @MAN1EXT@ ,
.MR @g@pic @MAN1EXT@ ,
.MR @g@eqn @MAN1EXT@
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_mmroff_1_man_C]
.do rr *groff_mmroff_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
