.TH gropdf @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
gropdf \-
.I groff
output driver for Portable Document Format
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright 2011-2025 Free Software Foundation, Inc.
.\"                2026 G. Branden Robinson
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_gropdf_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.\" This macro definition is poor style from a portability standpoint,
.\" but it's a good test and demonstration of the standard font
.\" repertoire for the devices where it has any effect at all, and so
.\" should be retained.
.de FT
.  if '\\*(.T'ps' .ft \\$1
.  if '\\*(.T'pdf' .ft \\$1
..
.
.\" This man page employs an unusual character.
.if !c \[u2717] .char \[u2717] X
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY gropdf
.RB [ \-delsW ]
.RB [ \-F\~\c
.IR font-directory ]
.RB [ \-I\~\c
.IR inclusion-directory ]
.RB [ \-\-opt\~\c
.IR option-bits ]
.RB [ \-p\~\c
.IR paper-format ]
.RB [ \-\-pdfver\~\c
.RB { 1.4 \||\| 1.7 }]
\#.RB [ \-w\~\c
\#.IR n ]
.RB [ \-u
.RI [ cmap-file ]]
.RB [ \-y\~\c
.IR foundry ]
.RI [ file\~ .\|.\|.]
.YS
.
.
.P
.SY gropdf
.B \-\-help
.YS
.
.
.P
.SY gropdf
.B \-v
.YS
.
.SY gropdf
.B \%\-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
The GNU
.I roff
PDF output driver translates the output of
.MR @g@troff @MAN1EXT@
into Portable Document Format.
.
Normally,
.I gropdf
is invoked by
.MR groff @MAN1EXT@
when the latter is given the
.RB \[lq] \-T\~pdf \[rq]
option.
.
(In this installation,
.B @DEFAULT_DEVICE@
is the default output device.)
.
Use
.IR groff 's
.B \-P
option to pass any options shown above to
.IR gropdf .
.
If no
.I file
arguments are given,
or if
.I file
is \[lq]\-\[rq],
.I gropdf
reads the standard input stream.
.
It writes to the standard output stream.
.
.
.P
See section \[lq]Font installation\[rq] below for a guide to installing
fonts for
.IR gropdf .
.
.
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \%\-\-version
show version information;
all exit afterward.
.
.
.TP 8n \" "-F dir" + 2n
.B \-d
Include debug information as comments within the PDF.
.
Also produces an uncompressed PDF.
.
.
.TP
.B \-e
Forces
.I gropdf
to embed
.I all
fonts (even the 14 base PDF fonts).
.
.
.TP
.BI \-F " dir"
Prepend directory
.IR dir /dev name
to the search path for font, and device description files;
.I name
is the name of the device, usually
.BR pdf .
.
.TP
.BI \-I\~ dir
Search the directory
.I dir
for files named in
.B \[rs]X\[aq]pdf: pdfpic\[aq]
device extension commands.
.
.B \-I
may be specified more than once;
each
.I dir
is searched in the given order.
.
To search the current working directory before others,
add
.RB \[lq] "\-I .\&" \[rq]
at the desired place;
it is otherwise searched last.
.
.
.TP
.B \-l
Orient the document in landscape format.
.
.TP
.BI \-\-opt\~ option-bits
Specify advanced options for
.I gropdf.
.I option-bits
is a bit vector that selects active features.
.
Add the following values to combine them.
.
.
.LP
.RS \" One inset to align with the indentation of `TP`...
.RS \" ...and one more to get "inboard" of it.
.TS
L  L
Lb Lx.
Value	Meaning
_
1	Subset included Type 1 fonts.
2	T{
Use more compact format for text by including space as a character.
Fonts that do not include space as a glyph
may conflict with this feature.
T}
4	T{
Compress all streams.
T}
8	T{
.\" Why don't we flip the sense of this bit and the default can be
.\" 15--all bits on?  See Savannah #66342.  --GBR
Don't embed font files.
.
(A font required by the document is not embedded;
usually not useful.)
T}
.TE
.RE
.LP
The default feature combination is 7.
.
To mimic what
.I gropdf
from
.I groff
1.23 produced,
specify \[lq]6\[rq] to turn off subsetting.
.RE
.
.
.TP
.BI \-p " paper-format"
Set the physical dimensions of the output medium.
.
This overrides the
.BR papersize ,
.BR paperlength ,
and
.B paperwidth
directives in the
.I DESC
file;
it accepts the same arguments as the
.B papersize
directive.
.
See
.MR groff_font @MAN5EXT@
for details.
.
.
.TP
.BR "\-\-pdfver " { 1.4 \||\| 1.7 }
PDF version 1.7 introduced a more compact object format;
this is now the default.
.
If you require the original format
(as produced by
.I gropdf
1.23)
set the version to
.BR 1.4 .
.
.
.TP
.B \-s
Append a comment line to end of PDF showing statistics,
i.e.\& number of pages in document.
.
Ghostscript's
.B ps2pdf
complains about this line if it is included, but works anyway.
.
.
.TP
.BR \-u \~[\c
.IR cmap-file ]
.I gropdf
normally includes a ToUnicode CMap with any font created using
.I text.enc
as the encoding file,
this makes it easier to search for words which contain ligatures.
.
You can include your own CMap by specifying a
.I cmap-file
or have no CMap at all by omitting the argument.
.
.
.TP
.B \-W
Exit with failure status if any warnings are issued.
.
.
.\" .TP
.\" .BI \-w n
.\" Lines should be drawn using a thickness of
.\" .IR n \~\c
.\" thousandths of an em.
.\" .
.\" If this option is not given, the line thickness defaults to
.\" 0.04\~em.
.\" .
.\" .
.TP
.BI \-y " foundry"
Set the foundry to use for selecting fonts of the same name.
.
.
.\" ====================================================================
.SH Usage
.\" ====================================================================
.
.IR gropdf 's
input must be in the format produced by
.MR @g@troff @MAN1EXT@
and described in
.MR groff_out @MAN5EXT@ .
.
Further,
its device and font description files must meet certain requirements.
.
The device
.B resolution
must be an integer multiple of\~72 times
.BR sizescale .
.
By default,
.I gropdf
uses a
.B resolution
of 72000 and a
.B sizescale
of 1000.
.
A valid paper format is mandatory;
see
.MR groff_font @MAN5EXT@ .
.
While the PDF standard allows several font file formats
(like TrueType),
at present
.I gropdf
accepts only the same Type\~1 Adobe PostScript format as
.MR grops @MAN1EXT@ .
.
Fewer Type\~1 fonts are supported natively in PDF documents than the
standard 35 fonts supported by
.I grops
and PostScript printers, \" XXX: strictly, PostScript Level 2, right?
but all are available since
.I gropdf
automatically embeds any that aren't specified by the PDF standard.
.
.
.P
.I gropdf
supports
.I foundries
that permit multiple providers to supply the same
.I groff
font names.
.
.IR groff 's
compilation process
attempts to locate Type\~1 fonts on the system,
populates a
.I Foundry
file with their locations,
and generates font description files corresponding to them.
.
Font description files can also be added after installation.
Each such file must contain a directive
.RS
.BI internalname\  psname
.RE
that maps the
.I groff
font name
(such as \[lq]TR\[rq])
to a PostScript name
(such as \[lq]Times\-Roman\[rq]).
.
Lines starting with
.B #
and blank lines are ignored.
.
The code for each character given in the font file must correspond
to the code in the default encoding for the font.
.
This code can be used with the
.B \[rs]N
escape sequence in
.I @g@troff
to select the character
even if it lacks a special character name.
.
Every character in the font description must exist in the font file,
and the widths given in the description must match those used in the
font file.
.
See
.MR groff_font @MAN5EXT@ .
.\" .
.\" .
.\" .LP
.\" Note that
.\" .B grops
.\" is able to display all glyphs in a PostScript font, not only 256.
.\" .I enc_file
.\" (or the default encoding if no encoding file specified) just defines
.\" the order of glyphs for the first 256 characters;
.\" all other glyphs are accessed with additional encoding vectors which
.\" .B grops
.\" produces on the fly.
.
.
.P
.I gropdf
can automatically
.I embed
any downloadable fonts necessary to print the document.
.
Any fonts thus required must be listed in the file
.IR @FONTDIR@/\:\%devpdf/\:\%download ,
which should comprise lines of the form
.
.RS
.I "foundry font file-name"
.RE
.
where
.I foundry
is the foundry name, or blank for the default foundry;
.I font
is the PostScript name of the font,
and
.I file-name
is the name of the PFA or PFB font file,
and can be a pathname
(can contain slashes).
.
Any lines beginning with
.B #
and blank lines are ignored;
fields must be separated by tabs
(spaces are
.B not
allowed);
if
.I file-name
is not a pathname,
it is sought using the same mechanism as that used for
font metric files.
.\" XXX: This may be underspecified; do we mean groff font description
.\" files, or AFM files?  Also, gropdf does its own path searches rather
.\" than the stuff in libgroff so I'm not sure what "the same mechanism"
.\" means.  --GBR
.
The
.I download
file itself is also sought using this mechanism.
.
Foundry names are usually a single character
(such as \[oq]U\[cq] for the URW foundry)
or empty for the default foundry.
.
This default uses the same fonts as
.I Ghostscript
uses when it embeds fonts in a PDF file.
.
.
.P
The default stroke and fill colors are black.
.
.
.\" ====================================================================
. SS Typefaces
.\" ====================================================================
.
Styles called
.BR R ,
.BR I ,
.BR B ,
and
.B BI
mounted at font positions 1 to\~4.
.
Text fonts are grouped into families
.BR A ,
.BR BM ,
.BR C ,
.BR H ,
.BR HN ,
.BR N ,
.BR P ,
.RB and\~ T ,
each having members in each of these styles.
.
.
.RS
.TP 8n \" BMBI + 2n + hand-tuned for PDF
.B AR
.FT AR
AvantGarde-Book
.FT
.
.TQ
.B AI
.FT AI
AvantGarde-BookOblique
.FT
.
.TQ
.B AB
.FT AB
AvantGarde-Demi
.FT
.
.TQ
.B ABI
.FT ABI
AvantGarde-DemiOblique
.FT
.
.TQ
.B BMR
.FT BMR
Bookman-Light
.FT
.
.TQ
.B BMI
.FT BMI
Bookman-LightItalic
.FT
.
.TQ
.B BMB
.FT BMB
Bookman-Demi
.FT
.
.TQ
.B BMBI
.FT BMBI
Bookman-DemiItalic
.FT
.
.TQ
.B CR
.FT CR
Courier
.FT
.
.TQ
.B CI
.FT CI
Courier-Oblique
.FT
.
.TQ
.B CB
.FT CB
Courier-Bold
.FT
.
.TQ
.B CBI
.FT CBI
Courier-BoldOblique
.FT
.
.TQ
.B HR
.FT HR
Helvetica
.FT
.
.TQ
.B HI
.FT HI
Helvetica-Oblique
.FT
.
.TQ
.B HB
.FT HB
Helvetica-Bold
.FT
.
.TQ
.B HBI
.FT HBI
Helvetica-BoldOblique
.FT
.
.TQ
.B HNR
.FT HNR
Helvetica-Narrow
.FT
.
.TQ
.B HNI
.FT HNI
Helvetica-Narrow-Oblique
.FT
.
.TQ
.B HNB
.FT HNB
Helvetica-Narrow-Bold
.FT
.
.TQ
.B HNBI
.FT HNBI
Helvetica-Narrow-BoldOblique
.FT
.
.TQ
.B NR
.FT NR
NewCenturySchlbk-Roman
.FT
.
.TQ
.B NI
.FT NI
NewCenturySchlbk-Italic
.FT
.
.TQ
.B NB
.FT NB
NewCenturySchlbk-Bold
.FT
.
.TQ
.B NBI
.FT NBI
NewCenturySchlbk-BoldItalic
.FT
.
.TQ
.B PR
.FT PR
Palatino-Roman
.FT
.
.TQ
.B PI
.FT PI
Palatino-Italic
.FT
.
.TQ
.B PB
.FT PB
Palatino-Bold
.FT
.
.TQ
.B PBI
.FT PBI
Palatino-BoldItalic
.FT
.
.TQ
.B TR
.FT TR
Times-Roman
.FT
.
.TQ
.B TI
.FT TI
Times-Italic
.FT
.
.TQ
.B TB
.FT TB
Times-Bold
.FT
.
.TQ
.B TBI
.FT TBI
Times-BoldItalic
.FT
.RE
.
.
.br
.ne 3v
.P
Another text font is not a member of a family.
.
.RS
.TP 8n \" BMBI (above) + 2n + hand-tuned for PDF
.B ZCMI
.FT ZCMI
ZapfChancery-MediumItalic
.FT
.RE
.
.
.P
Special fonts include
.BR S ,
the PostScript Symbol font;
.BR SS ,
a subset of
.B S
with slanted lowercase Greek letters;
.BR EURO ,
which offers a Euro glyph
in several styles
for use with old devices lacking it;
and
.BR ZD ,
Zapf Dingbats.
.
In contrast to
.IR grops ,
.I gropdf
does not require a reversed variant of it
.RB ( ZDR );
the \[lq]hand pointing left\[rq] glyph
.RB ( \[rs][lh] )
is available nevertheless,
since
.I \%pdf.tmac
defines it using the
.B \[rs]X\[aq]pdf: xrev\[aq]
device extension command
(see below).
.
Some glyphs in these fonts are unnamed and must be accessed
as indexed characters,
using the
.B \[rs]N
escape sequence.
.
.P
The fonts corresponding to
.B EURO
and
.B SS
are unknown to the PDF standard;
.I groff
therefore provides their AFM files
(font metrics)
and PFA or PFB files
so that they can be used with other software
and embedded in PDF output.
.
.
.P
.I gropdf
furthermore supports a naming scheme for East Asian typefaces
shared with
.MR grohtml @MAN1EXT@ ,
.MR grops @MAN1EXT@ ,
and
.MR grotty @MAN1EXT@ .
.
.
.RS
.TP
.B CSH
Simplified Chinese,
Hei style
.
.TQ
.B CSS
Simplified Chinese,
Song style
.
.TQ
.B CTH
Traditional Chinese,
Hei style
.
.TQ
.B CTS
Traditional Chinese,
Song style
.
.TQ
.B JPG
Japanese,
Gothic style
.
.TQ
.B JPM
Japanese,
Mincho style
.
.TQ
.B KOG
Korean,
Gothic style
.
.TQ
.B KOM
Korean,
Mincho style
.RE
.
.
.\" ====================================================================
. SS "Device extension commands"
.\" ====================================================================
.
.I gropdf
supports many device extensions,
accessed with the
.I groff
request
.B \%device
or
.I roff
.B \[rs]X
escape sequence.
.
First,
it
understands many of the device extensions supported by
.MR grops 1 .
.
.
.TP
.B \[rs]X\[aq]ps: invis\[aq]
Suppress output.
.
.
.TP
.B \[rs]X\[aq]ps: endinvis\[aq]
Stop suppressing output.
.
.
.TP
.BI "\[rs]X\[aq]ps: exec gsave currentpoint 2 copy translate\~" n\~\c
.B rotate neg exch neg exch translate\[aq]
where
.I n
is the angle of rotation.
.
This is to support the
.B align
command in
.MR @g@pic 1 .
.
.
.TP
.B \[rs]X\[aq]ps: exec grestore\[aq]
Used by
.MR @g@pic 1
to restore state after rotation.
.
.
.TP
.BI "\[rs]X\[aq]ps: exec " "n\~" "setlinejoin\[aq]"
where
.I n
can be one of the following values.
.
.
.IP
0 = Miter join
.br
1 = Round join
.br
2 = Bevel join
.
.
.TP
.BI "\[rs]X\[aq]ps: exec " "n " "setlinecap\[aq]"
where
.I n
can be one of the following values.
.
.
.IP
0 = Butt cap
.br
1 = Round cap, and
.br
2 = Projecting square cap
.
.
.br
.ne 3v
.P
.I gropdf
also supports a subset of the commands introduced in
.IR gpresent 's
.IR present.tmac .
.
.
.RS
.TP
.B PAUSE
.TQ
.B BLOCKS
.TQ
.B BLOCKE
.RE
.
.
.P
These allow you to create presentation PDFs.
.
Many of the other
commands are already available in other macro packages.
.
.
.LP
These commands are implemented with
.I groff
X commands:-
.
.
.LP
.TP
.B \[rs]X\[aq]ps: exec %%%%PAUSE\[aq]
The section before this is treated as a block and is introduced using
the current
.B BLOCK
transition setting
(see
.RB \[lq] "\[rs]X\[aq]pdf: transition\[aq]" \[rq]
below).
.
Equivalently,
.B \%.pdfpause
is available as a macro.
.TP
.B \[rs]X\[aq]ps: exec %%%%BEGINONCE\[aq]
Any text following this command (up to %%%%ENDONCE) is shown only once,
the next %%%%PAUSE will remove it.
If producing a non-presentation PDF, i.e.\&
ignoring the pauses, see
.I \%GROPDF_NOSLIDE
below, this text is ignored.
.LP
.TP
.B \[rs]X\[aq]ps: exec %%%%ENDONCE\[aq]
This terminates the block defined by %%%%BEGINONCE.
This pair of commands
is what implements the \&.BLOCKS Once/.BLOCKE commands in
.IR present.tmac .
.
.
.LP
The
.I mom
macro package already integrates these extensions,
so you can build slides with
.IR mom .
.
.
.LP
If you use
.I present.tmac
with
.I gropdf
there is no need to run the program
.MR presentps @MAN1EXT@
since the output will already be a presentation PDF.
.
.
.LP
All other
.B ps:
tags are silently ignored.
.
.
.LP
.I gropdf
also recognizes a device extension used by the DVI driver.
.
.
.TP
.BI \[rs]X\[aq]papersize= width , length \[aq]
Set the page dimensions in centimeters to
.I width
by
.I length.
.
If the
.B \-l
option was specified,
these dimensions are swapped.
.
Changes to the paper dimensions should occur prior to the first page,
or during page ejection before starting a subsequent one.
.
.
.IP
.I Caution:
the ordering of dimensions differs from that used by
.I papersize.tmac
and
.MR @g@troff @MAN1EXT@ 's
.RB \[lq] "\-d \%paper" \[rq]
option.
.
.
.LP
.I gropdf
supports several more device extensions using the
.B pdf:
tag.
.
The following have counterpart
.I "convenience macros"
that take the same arguments and behave equivalently.
.
.
.TP
.BI ".pdfbackground " "cmd left top right bottom weight"
.TQ
.B ".pdfbackground off"
.TQ
.BI ".pdfbackground footnote " bottom
.TQ
.BI "\eX\[aq]pdf: background " "cmd left top right bottom weight" \[aq]
.TQ
.B "\eX\[aq]pdf: background off\[aq]"
.TQ
.BI "\eX\[aq]pdf: background footnote " bottom \[aq]
Produce a background rectangle on the page.
.
.
.RS
.TP 8n \" "bottom" + 2n
.I cmd
is the command,
which can be any of
.RB \[lq] page | fill | box \[rq]
in combination.
.
Thus,
.RB \[lq] pagefill \[rq]
would draw a rectangle which covers the whole current page size
(in which case the rest of the parameters can be omitted because the box
dimensions are taken from the current media size).
.
.RB \[lq] boxfill \[rq],
on the other hand,
requires the given dimensions to place the box.
.
Including
.RB \[lq] fill \[rq]
in the command paints the rectangle with the current fill colour
(as with
.BR \[rs]M[] )
and including
.RB \[lq] box \[rq]
gives the rectangle a border in the current stroke colour
(as with
.BR \[rs]m[] ).
.
.
.IP
.I cmd
may also be
.RB \[lq] off \[rq]
on its own,
which terminates drawing the current box.
.
If you have specified a page colour with
.RB \[lq] pagefill \[rq],
it is always the first box in the stack,
and if you specify it again,
it replaces the first entry.
.
Be aware that the
.RB \[lq]  pagefill \[rq]
box renders the page opaque,
so tools that \[lq]watermark\[rq] PDF pages are unlikely to be
successful.
.
To return the background to transparent,
issue an
.RB \[lq] off \[rq]
command with no other boxes open.
.
.
.IP
Finally,
.I cmd
may be
.RB \[lq] footnote \[rq]
followed by a new value for
.IR bottom ,
which is used for all open boxes on the current page.
This is to allow room for footnote areas that grow while a page is
processed
(to accommodate multiple footnotes,
for instance).
.
(If the value is negative,
it is used as an offset from the bottom of the page.)
.
.
.TP
.I left
.TQ
.I top
.TQ
.I right
.TQ
.I bottom
are the coordinates of the box.
.
The
.I top
and
.I bottom
coordinates are the minimum and maximum for the box,
since the actual start of the box is
.IR groff 's
drawing position when you issue the command,
and the bottom of the box is the point where you turn the box
.RB \[lq] off \[rq].
.
The top and bottom coordinates are used only if the box drawing extends
onto the next page;
ordinarily,
they would be set to the header and footer margins.
.
.
.TP
.I weight
provides the line width for the border if
.RB \[lq] box \[rq]
is included in the command.
.
.
.P
An
.I sboxes
macro file is also available;
see
.MR groff_tmac @MAN5EXT@ .
.RE
.
.
.br
.ne 5v
.TP
.BI ".pdfmarkstart " /ANN-definition
.TQ
.B .pdfmarkend
.TQ
.BI "\[rs]X\[aq]pdf: markstart " /ANN-definition \[aq]
.TQ
.B \[rs]X\[aq]pdf: markend\[aq]
Macros that support PDF bookmarks use these calls internally to
start and stop (respectively) the placement of the bookmark's
.I hotspot;
the user will have called
.RB \[lq] .pdfhref\~L \[rq]
with the text of the hotspot.
.
.
.TP
.B .pdfmarksuspend
.TQ
.B .pdfmarkrestart
.TQ
.B \[rs]X\[aq]pdf: marksuspend\[aq]
.TQ
.B \[rs]X\[aq]pdf: markrestart\[aq]
If you use a page location trap to produce a header or footer,
or otherwise interrupt a document's text,
you need to use these commands if a PDF
.I hotspot
crosses a trap boundary;
otherwise any text output by the trap will be marked as part
of the hotspot.
.
To prevent this error,
place these device extension escape sequences or their corresponding
convenience macros
.B \%.pdfmarksuspend
and
.B \%.pdfmarkrestart
at the start and end of the trap macro,
respectively.
.
.
.TP
.BI ".pdfpagename " name
.TQ
.BI "\[rs]X\[aq]pdf: pagename " name \[aq]
Assign the current page a
.IR name .
.
All documents bear two default names,
.RB \[oq] top "\[cq] and \[oq]" bottom \[cq].
.
.
.TP
.BI ".pdfpagenumbering " "type prefix start"
.TQ
.BI "\[rs]X\[aq]pdf: pagenumbering " "type prefix start" \[aq]
.RS
Control the page numbering shown in a PDF reader's outline
(which also contains bookmarks).
.
Normally,
the page number associated with each bookmark is its sequence number in
the file,
but this might not match the desired numbering scheme.
.
A document may bear a cover sheet
(which has no page number);
front matter
(possibly including a table of contents)
that uses lowercase roman numerals;
the main matter,
which uses arabic numerals;
and back matter,
which may include appendices that are each prefixed with a letter and
independently numbered.
.
Place this command prior to breaking the page to which the new numbering
scheme is to apply.
.
It then persists until changed again.
.
.
.P
.TP 8n \" "prefix" + 2n
.I type
specifies the numbering system to use. It
should be one of
.RB \[lq] Decimal \[rq],
.RB \[lq] Roman \[rq],
.RB \[lq] roman \[rq],
.RB \[lq] Alpha \[rq],
or
.RB \[lq] alpha \[rq].
.
This parameter may be abbreviated to the first letter,
whose lettercase determines that used for the numbers where applicable.
.
The ordering used by the alphabetic numbering systems is
A-Z \&.\|.\|.\& AA-AZ \&.\|.\|.\& ZA-ZZ.
.
.I type
can also be
.RB \[lq] .\& \[rq],
which selects no numbering system;
you may still provide a
.I prefix.
.
.
.TP
.I prefix
specifies text to precede the page number.
.
For example,
to number the pages of an appendix
\[lq]A-1\[rq],
\[lq]A-2\[rq],
and so forth,
use a
.I prefix
of
.RB \[lq] A- \[rq]
and a
.I type
of
.RB \[lq] Decimal \[rq].
.
.
.TP
.I start
determines the page number.
.
It defaults to 1.
.RE
.
.
.TP
.BI ".pdfpic " "file alignment width height line-length"
.TQ
.\" XXX: For consistency, this device extension command should be "pic".
.\" --GBR
.BI "\[rs]X\[aq]pdf: pdfpic " file\~\c
.IB "alignment width height line-length" \[aq]
Place an image from file
.I file
of desired
.I width
and
.I height
(if
.I height
is missing or zero then it is scaled proportionally).
.
If
.I alignment
is
.B \-L
the drawing is left-aligned.
.
If it is
.B \-C
or
.B \-R
a
.I line-length
greater than the width of the drawing is required as well.
.
If
.I width
is specified as zero then the width is scaled in proportion to the
height.
.
If both
.I width
and
.I height
are non-zero the image is scaled to \[oq]best fit\[cq].
.
.
.IP
The availability of other software on the system,
such as
.IR PerlMagick ,
influences the types of image files
.I gropdf
can embed in its output.
.
.
.IP
.TS
allbox center;
Cb Ci Ci Ci Ci
Li C  C  C  C.
\&	\fRnone	file\fR(1)	identify\fR(1)	Image::Magick\fR(3pm)
\&.pdf	\[OK]	\[OK]	\[OK]	\[OK]
\&.jpg	\[u2717]	\[OK]	\[OK]	\[OK]
\&.jp2	\[u2717]	\[u2717]	\[OK]	\[OK]
\fRother	\[u2717]	\[u2717]	\[u2717]	\[OK]
.TE
.
.
.IP
See
.MR groff_tmac @MAN5EXT@
for a description of the
.B \%PDFPIC
macro,
which provides a convenient high-level interface for inclusion of
various graphic file formats.
.
.
.TP
.BI ".pdfswitchtopage " "when name"
.TQ
.BI "\[rs]X\[aq]pdf: switchtopage " "when name" \[aq]
Normally each new page is appended to the end of the document,
this command allows following pages to be inserted at a
.I \[oq]named\[cq]
position within the document (see pagename command above).
.I \[oq]when\[cq]
can be either
.RI \[oq] after "\[cq] or \[oq]" before \[cq].
If it is omitted it defaults to
.RI \[oq] before \[cq].
.
It should be used at the end of the page before you want the switch to
happen.
.
This allows pages such as a TOC to be moved to elsewhere in the
document,
but more esoteric uses are possible.
.
.
.TP
.BI ".pdftransition " "scope mode duration dimension motion direction\
 scale bool"
.TQ
.BI "\[rs]X\[aq]pdf: transition " scope\~\c
.IB "mode duration dimension motion direction scale bool" \[aq]
Configure the style of page transitions,
as used in \[lq]slides\[rq]
(or \[lq]foils\[rq]).
.
.I scope
can be either
.B SLIDE
or
.BR BLOCK .
.
.B SLIDE
applies the transition when a new slide is introduced to the screen;
.B BLOCK
applies it to the individual blocks making up the slide.
.
.
.IP
.I mode
is the transition type between slides:-
.RS
.IP
.B Split
- Two lines sweep across the screen, revealing the new page.
The lines
may be either horizontal or vertical and may move inward from the
edges of the page or outward from the center, as specified by the
.I dimension
and
.I motion
entries, respectively.
.br
.B Blinds
- Multiple lines, evenly spaced across the screen, synchronously
sweep in the same direction to reveal the new page.
The lines may be
either horizontal or vertical, as specified by the
.I dimension
entry.
Horizontal
lines move downward; vertical lines move to the right.
.br
.B Box
- A rectangular box sweeps inward from the edges of the page or
outward from the center, as specified by the
.I motion
entry, revealing the new page.
.br
.B Wipe
- A single line sweeps across the screen from one edge to the other in
the direction specified by the
.I direction
entry, revealing the new page.
.br
.B Dissolve
- The old page dissolves gradually to reveal the new one.
.br
.B Glitter
- As Dissolve,
except that the effect sweeps across the page in a wide band moving from
one side of the screen to the other in the direction specified by the
.I direction
entry.
.br
.B R
- The new page simply replaces the old one with no special transition
effect; the
.I direction
entry shall be ignored.
.br
.B Fly
- (PDF 1.5) Changes are flown out or in (as specified by
.IR motion ),
in the
direction specified by
.IR direction ,
to or from a location that is offscreen except
when
.I direction
is
.BR None .
.br
.B Push
- (PDF 1.5) The old page slides off the screen while the new page
slides in, pushing the old page out in the direction specified by
.IR direction .
.br
.B Cover
- (PDF 1.5) The new page slides on to the screen in the direction
specified by
.IR direction ,
covering the old page.
.br
.B Uncover
- (PDF 1.5) The old page slides off the screen in the direction
specified by
.IR direction ,
uncovering the new page in the direction
specified by
.IR direction .
.br
.B Fade
- (PDF 1.5) The new page gradually becomes visible through the
old one.
.LP
.RE
.IP
.I duration
is the length of the transition in seconds (default 1).
.LP
.IP
.I dimension
(Optional;
.BR Split " and " Blinds
transition styles only) The dimension in which the
specified transition effect shall occur:
.B H
Horizontal, or
.B V
Vertical.
.LP
.IP
.I motion
(Optional;
.BR Split ,
.BR Box " and " Fly
transition styles only) The direction of motion for
the specified transition effect:
.B I
Inward from the edges of the page, or
.B O
Outward from the center of the page.
.LP
.IP
.I direction
(Optional;
.BR Wipe ,
.BR Glitter ,
.BR Fly ,
.BR Cover ,
.BR Uncover " and " Push
transition styles only)
The direction in which the specified transition effect shall moves,
expressed in degrees counterclockwise starting from a left-to-right
direction.
If the value is a number, it shall be one of:
.B 0
= Left to right,
.B 90
= Bottom to top (Wipe only),
.B 180
= Right to left (Wipe only),
.B 270
= Top to bottom,
.B 315
= Top-left to bottom-right (Glitter only)
The value can be
.BR None ,
which is relevant only for the
.B Fly
transition when the value of
.I scale
is not 1.0.
.LP
.IP
.I scale
(Optional; PDF 1.5;
.B Fly
transition style only) The starting or ending scale at
which the changes shall be drawn.
If
.I motion
specifies an inward transition, the scale
of the changes drawn shall progress from
.I scale
to 1.0 over the course of the
transition.
If
.I motion
specifies an outward transition, the scale of the changes drawn
shall progress from 1.0 to
.I scale
over the course of the transition
.LP
.IP
.I bool
(Optional; PDF 1.5;
.B Fly
transition style only) If
.BR true ,
the area that shall be flown
in is rectangular and opaque.
.LP
.IP
Any of the parameters may be
replaced with a "." which signifies the parameter retains its
previous value, also any trailing missing parameters are ignored.
.LP
.IP
.B Note:
not all PDF Readers support any or all these transitions.
.LP
.
.
.TP
.\" XXX: No convenience macro for this one?  --GBR
.B \[rs]X\[aq]pdf: xrev\[aq]
Toggle the reversal of glyph direction.
.
This feature works by reversing all following text.
Each separate letter is also mirrored.
.
One application is the reversal of glyphs in the Zapf Dingbats font.
.
To restore the normal glyph orientation,
repeat the command.
.
.
.\" ====================================================================
.SS Macros
.\" ====================================================================
.
.IR gropdf 's
support macros in
.I pdf\.tmac
define the convenience macros described above.
.
Some features have no direct device extension escape sequence
counterpart.
.
.
.TP
.BR ".pdfbookmark " [ \-T\~\c
.IR tag-name ]\~ "level text"
Mark the nearest page location as a bookmark,
and optionally a named destination as well.
.
.I Bookmarks
populate the outline pane of the reader.
.
They are organized into a hierarchical tree;
each level of the tree is numbered,
starting at 1,
and named as
.I text
in the outline.
.
.I "Named destinations"
permit hyperlink-style navigation within the document.
.
Specifying
.B \-T
followed by
.I tag-name
creates a named destination
making the page location eligible as a target named by
.RB \[lq] ".pdfhref L" \~.\|.\|.\&\[rq].
.
.
.TP
.BR ".pdfhref L" \~\c
.BI \-D\~ dest\~\c
.RB [ \-S ] \~\c
.RB [ \-P \~\c
.IR prefix-text "] \c"
.RB [ \-A \~\c
.IR suffix-text "] \c"
.RI [ link-text ]
Create a hotspot link to
.I dest,
which a
.RB \[lq] .pdfbookmark \~.\|.\|.\&\[rq]
or
.RB \[lq] ".pdfhref M" \~.\|.\|.\&\[rq]
call elsewhere in the document should define.
.
(If the document employs forward references,
it must be processed twice;
see
.MR pdfmom @MAN1EXT@ .)
.
If
.I link-text
is omitted,
.I dest
is formatted as the link text.
.
The
.B \-P
and
.B \-A
arguments format their successors as text
before and after the link text,
respectively,
without intervening space.
.
Specifying
.B \-S
prevents
.B pdfhref
from \[lq]closing\[rq] the hotspot,
requiring the document
(or macro package wrapping
.BR pdfhref )
to do so itself with
.B \%pdfmarkend
or
.RB \[lq] "\[rs]X\[aq]pdf: markend\[aq]" \[rq].
.
.
.TP
.BR ".pdfhref M" \~\c
.RB [ \-E ]\~\c
.RB [ \-N \~\c
.IR tag-name ]\~\c
.I dest
Mark the nearest page location as a destionation named
(the first word of)
.I dest,
which should be unique within a document.
.
Specifying
.B \-T
followed by
.I tag-name
overrides this default.
.
Specifying
.B \-E
formats
.I dest
as text in the document as well.
.
.
.TP
.BR ".pdfhref W" \~\c
.BI \-D\~ uri\~\c
.RB [ \-S ] \~\c
.RB [ \-P \~\c
.IR prefix-text "] \c"
.RB [ \-A \~\c
.IR suffix-text "] \c"
.I link-text
.\" The link-text argument is not, presently, optional.  See Savannah
.\" #67916.
.\" RI [ link-text ]
Create a hotspot link to
.I uri,
a World Wide Web
Universal Resource Identifer (URI).
.
.\" XXX: Nope--pdf.tmac formats "Unknown" as the link text instead.  See
.\" Savannah #67916.
.\" If
.\" .I link-text
.\" is omitted,
.\" .I uri
.\" is formatted as the link text.
.
The
.B \-P
and
.B \-A
arguments format their successors as text
before and after the link text,
respectively,
without intervening space.
.
Specifying
.B \-S
prevents
.B pdfhref
from \[lq]closing\[rq] the hotspot,
requiring the document
(or macro package wrapping
.BR pdfhref )
to do so itself with
.B \%pdfmarkend
or
.RB \[lq] "\[rs]X\[aq]pdf: markend\[aq]" \[rq].
.
.
.TP
.\" XXX: We don't need to expose PDF's '/' syntax in a *roff macro
.\" file.  It should prefix "field" with '/' itself.  -- GBR
.BI ".pdfinfo /" "field content"\~\c
\&.\|.\|.
Define PDF metadata.
.
.I field
may be one of
.BR Title ,
.BR Author ,
.BR Subject ,
.BR Keywords ,
or another datum supported by the PDF standard or your reader.
.
.I field
must be prefixed with a slash.
.
.
.TP
.BR ".pdfnote " [ \-T\~\c
.IR title ]\~ text
Create an annotation in the document.
.
Reader support for this feature varies.
.
Some place an icon in the margin;
hovering over the icon reveals any
.IR title ,
while clicking on the icon
pops up a window containing
.IR text .
.
.
.\" ====================================================================
.SS "Importing graphics"
.\" ====================================================================
.
.I gropdf
supports only the inclusion of other PDF files for inline images.
.
Such a PDF file may,
however,
contain any of the graphic formats supported by
the PDF standard,
such as JPEG/JFIF,
PNG,
and GIF.
.
Any application that outputs PDF can thus be used to prepare files for
embedding in documents processed by
.I groff
and
.IR gropdf .
.
.
.P
The PDF file you wish to insert must be a single page and the drawing
must just fit inside the media size of the PDF file.
.
In
.MR inkscape 1
or
.MR gimp 1 ,
for example,
make sure the canvas size just fits the image.
.
.
.P
The PDF parser
.I gropdf
implements has not been rigorously tested with all applications that
produce PDF.
.
If you find a single-page PDF which fails to import properly,
try processing it with the
.MR pdftk 1
program.
.
.
.RS
.EX
pdftk\~\c
.I existing-file\~\c
output\~\c
.I new-file
.EE
.RE
.
You may find that
.I new-file
imports successfully.
.
.
.\" ====================================================================
.SS "TrueType and other font formats"
.\" ====================================================================
.
.I gropdf
does not yet support any font formats besides Adobe Type 1
(PFA or PFB).
.
.
.\" ====================================================================
.SH "Font installation"
.\" ====================================================================
.
The following is a step-by-step font installation guide for
.I gropdf.
.
.
.IP \[bu] 3n
Convert your font to something
.I groff
understands.
.
This is a PostScript Type\~1 font in PFA or PFB format,
together with an AFM file.
.
A PFA file begins as follows.
.
.RS
.RS \" two RS calls to get inboard of IP indentation
.EX
%!PS\-AdobeFont\-1.0:
.EE
.RE \" but only one to get back to it
.
A PFB file contains this string as well,
preceded by some non-printing bytes.
.
In the following steps,
we will consider the use of CTAN's
.UR https://\:ctan.org/\:tex\-archive/\:fonts/\:brushscr
BrushScriptX-Italic
.UE
font in PFA format.
.RE \" now restore left margin
.
.
.IP \[bu]
Convert the AFM file to a
.I groff
font description file with the
.MR afmtodit @MAN1EXT@
program.
.
For instance,
.
.RS
.RS \" two RS calls to get inboard of IP indentation
.EX
$ \c
.B afmtodit BrushScriptX\-Italic.afm text.map BSI
.EE
.RE \" but only one to get back to it
.
converts the Adobe Font Metric file
.I BrushScriptX\-Italic.afm
to the
.I groff
font description file
.IR BSI .
.RE \" now restore left margin
.
.
.IP
If you have a font family which provides regular upright (roman),
bold,
italic,
and
bold-italic styles,
(where \[lq]italic\[rq] may be \[lq]oblique\[rq] or \[lq]slanted\[rq]),
we recommend using
.BR R ,
.BR B ,
.BR I ,
and
.BR BI ,
respectively,
as suffixes to the
.I groff
font family name to enable
.IR groff 's
font family and style selection features.
.
An example is
.IR groff 's
built-in support for Times:
the font family
name is abbreviated as
.BR T ,
and the
.I groff
font names are therefore
.BR TR ,
.BR TB ,
.BR TI ,
and
.BR TBI .
.
In our example,
however,
the BrushScriptX font is available in a single style only,
italic.
.
.
.IP \[bu]
Install the
.I groff
font description file(s) in a
.I devpdf
subdirectory in the search path that
.I groff
uses for device and font file descriptions.
.
See the
.I GROFF_FONT_PATH
entry in section \[lq]Environment\[rq] of
.MR @g@troff @MAN1EXT@
for the current value of the font search path.
.
While
.I groff
doesn't directly use AFM files,
it is a good idea to store them alongside its font description files.
.
.
.IP \[bu]
Register fonts in the
.I devpdf/download
file so they can be located for embedding in PDF files
.I gropdf
generates.
.
Only the first
.I download
file encountered in the font search path is read.
.
If in doubt,
copy the default
.I download
file
(see section \[lq]Files\[rq] below)
to the first directory in the font search path and add your fonts there.
.
The PostScript font name used by
.I gropdf
is stored in the
.B internalname
field in the
.I groff
font description file.
.
(This name does not necessarily resemble the font's file name.)
.
If the font in our example had originated from a foundry named
.BR Z ,
we would add the following line to
.IR download .
.
.RS
.RS \" two RS calls to get inboard of IP indentation
.EX
Z\[->]BrushScriptX\-Italic\[->]BrushScriptX\-Italic.pfa
.EE
.RE \" but only one to get back to it
.
A tab character,
depicted as \[->],
separates the fields.
.
The default foundry has no name:
its field is empty and
entries corresponding to it start with a tab character,
as will the one in our example.
.RE \" now restore left margin
.
.
.IP \[bu]
Test the selection and embedding of the new font.
.
.RS
.RS \" two RS calls to get inboard of IP indentation
.EX
printf "\[rs]\[rs]f[BSI]Hello, world!\[rs]n" \
| groff \-T pdf \-P \-e >hello.pdf
see hello.pdf
.EE
.RE
.RE
.
.
.\" ====================================================================
.SH "Exit status"
.\" ====================================================================
.
.IP 0
.I gropdf
successfully produced a PDF document.
.
.
.IP 1
.I gropdf
experienced a critical error,
or warnings were emitted and the
.B \-W
option was specified.
.
.
.IP 2
.I gropdf
could not interpret its command-line arguments.
.
.
.br
.ne 5v
.\" ====================================================================
.SH Environment
.\" ====================================================================
.
.TP
.I GROFF_FONT_PATH
A list of directories in which to seek the selected output device's
directory of device and font description files.
.
If,
in the
.I download
file,
the font file has been specified with a full path,
no directories are searched.
.
See
.MR @g@troff @MAN1EXT@
and
.MR groff_font @MAN5EXT@ .
.
.
.TP
.I GROPDF_NOSLIDE
If set and evaluates to a true value
(to Perl),
.\" XXX: The above is inconsistent with the way grotty(1) handles
.\" "GROFF_NO_SGR".
.I gropdf
ignores commands specific to presentation PDFs,
producing a normal PDF instead.
.
.
.TP
.I GROPDF_OPTIONS
.I gropdf
interprets the contents of this environment variable
as a space-separated list of command-line options.
.
Explicit command-line options override any settings
from this environment variable.
.
.
.TP
.I SOURCE_DATE_EPOCH
A timestamp
(expressed as seconds since the Unix epoch)
to use as the output creation timestamp in place of the current time.
.
The time is converted to human-readable form using Perl's
.I \%gmtime()
function and recorded in a PDF comment.
.
.
.TP
.I TZ
The time zone to use when converting the current time to human-readable form;
see
.MR tzset 3 .
If
.I SOURCE_DATE_EPOCH
is used, it is always converted to human-readable form using UTC.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I @FONTDIR@/\:\%devpdf/\:DESC
describes the
.B pdf
output device.
.
.
.TP
.IR @FONTDIR@/\:\%devpdf/ F
describes the font known
.RI as\~ F
on device
.BR pdf .
.
.
.TP
.IR @FONTDIR@/\:\%devpdf/\:U\- F
describes the font
from the URW foundry
(versus the Adobe default)
known
.RI as\~ F
on device
.BR pdf .
.
.
.TP
.I @FONTDIR@/\:\%devpdf/\%download
lists fonts available for embedding within the PDF document
(by analogy to the
.B ps
device's downloadable font support).
.
.
.\" XXX: Why are we shipping this but not BuildFoundries.pl?
.TP
.I @FONTDIR@/\:\%devpdf/\%Foundry
is a data file used by the
.I groff
build system to locate PostScript Type\~1 fonts.
.
.
.TP
.I @FONTDIR@/\:\%devpdf/\:\%symbolsl\:.afm
provides metrics for the slanted symbol font known to
.I groff
as
.BR SS .
.
These data facilitate use of the font with
.RI non- groff
software.
.
.
.TP
.I @FONTDIR@/\:\%devpdf/\:\%symbolsl\:.pfb
supplies the slanted symbol font known to
.I groff
as
.BR SS .
.
.
.TP
.I @FONTDIR@/\:\%devpdf/\:enc/\:\%text\:.enc
describes the encoding scheme used by most PostScript Type\~1 fonts;
the
.B \%encoding
directive of
font description files for the
.B pdf
device refers to it.
.
.
.TP
.I @FONTDIR@/\:\%devpdf/\:\%generate/\:\%symbolsl\:.sfd
is the source form of the
.I \%symbolsl.pfb
font,
in spline font database (SFD) format.
.
.
.TP
.I @MACRODIR@/\:pdf\:.tmac
defines macros for use with the
.B pdf
output device.
.
It is automatically loaded by
.I troffrc
when the
.B pdf
output device is selected.
.
.
.TP
.I @MACRODIR@/\:\%pdfpic\:.tmac
defines the
.B PDFPIC
macro for embedding images in a document;
see
.MR groff_tmac @MAN5EXT@ .
.
It is automatically loaded by
.I troffrc.
.\"
.\"
.\" .TP
.\" .B @MACRODIR@/pspic.tmac
.\" Definition of
.\" .B PSPIC
.\" macro,
.\" automatically loaded by
.\" .BR ps.tmac .
.\" .
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
.I gropdf
was written and is maintained by
.MT deri@\:chuzzlewit\:.myzen\:.co\:.uk
Deri James
.ME .
.
.
.br
.ne 3v
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.TP
.I @DOCDIR@/\:\%sboxes/\:\%msboxes\:.ms
.TQ
.I @DOCDIR@/\:\%sboxes/\:\%msboxes\:.pdf
\[lq]Using PDF boxes with
.I groff
and the
.I ms
macros\[rq],
by Deri James.
.
.
.TP
.I present.tmac
is part of
.UR https://\:bob\:.diertens\:.org/\:corner/\:useful/\:gpresent/
.I gpresent
.UE ,
a software package by Bob Diertens that works with
.I groff
to produce presentations
(\[lq]foils\[rq],
or \[lq]slide decks\[rq]).
.
.
.P
.MR afmtodit @MAN1EXT@ ,
.MR groff @MAN1EXT@ ,
.MR @g@troff @MAN1EXT@ ,
.MR groff_font @MAN5EXT@ ,
.MR groff_out @MAN5EXT@
.\" Not actually referenced in above discussion.
.\" .BR \%pfbtops (@MAN1EXT@),
.\" .BR \%groff_tmac (@MAN5EXT@),
.
.
.\" Clean up.
.rm FT
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_gropdf_1_man_C]
.do rr *groff_gropdf_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
