.TH afmtodit @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
afmtodit \- adapt Adobe Font Metrics files for
.I groff
PostScript and PDF output
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2025 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_afmtodit_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY afmtodit
.RB [ \-ckmnqsx ]
.RB [ \-a\~\c
.IR slant ]
.RB [ \-d\~\c
.IR device-description-file ]
.RB [ \-e\~\c
.IR encoding-file ]
.RB [ \-f\~\c
.IR internal-name ]
.RB [ \-i\~\c
.IR italic-correction-factor ]
.RB [ \-o\~\c
.IR output-file ]
.RB [ \-w\~\c
.IR space-width ]
.I afm-file
.I map-file
.I font-description-file
.YS
.
.
.P
.SY afmtodit
.B \-\-help
.YS
.
.
.P
.SY afmtodit
.B \-v
.YS
.
.SY afmtodit
.B \%\-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I \%afmtodit
generates a font description file for use with
.MR groff 1 's
.B ps
and
.B pdf
output devices from an
Adobe Font Metric
file,
.IR afm-file .
.
.I map-file
associates a
.I groff
ordinary or special character name with a PostScript glyph name.
.
Output is written in
.MR groff_font @MAN5EXT@
format to
.I font-description-file,
a file named for the intended
.I groff
font name
(but see the
.B \-o
option).
.
.
.LP
.I map-file
should contain a sequence of lines of the form
.
.RS
.EX
.I ps-glyph groff-char
.EE
.RE
.
where
.I ps-glyph
is the PostScript glyph name and
.I groff-char
is a
.I groff
ordinary
(if of unit length)
or special
(if longer)
character identifier.
.
The same
.I ps-glyph
can occur multiple times in the file;
each
.I groff-char
must occur at most once.
.
Lines starting with \[lq]#\[rq] and blank lines are ignored.
.
If the file isn't found in the current directory,
it is sought in the
.I devps/generate
subdirectory of the default font directory.
.
.
.LP
If a PostScript glyph is not mentioned in
.IR map-file ,
and a
.I groff
character name can't be deduced using the Adobe Glyph List
(AGL,
built into
.IR afmtodit ),
then
.I \%afmtodit
puts the PostScript glyph into the
.I groff
font description file as an unnamed glyph which can only be accessed
by the \[lq]\eN\[rq] escape sequence in a
.I roff
document.
.
In particular,
this is true for glyph variants named in the form
.RI \[lq] foo . bar \[rq];
all glyph names containing one or more periods are mapped to unnamed
entities.
.
Unless
.B \-e
is specified,
the encoding defined in the AFM file
(i.e.,
entries
with non-negative codes)
is used.
.
Refer to section \[lq]Using Symbols\[rq] in
.IR "Groff: The GNU Implementation of troff" ,
the
.I groff
Texinfo manual,
or
.MR groff_char @MAN7EXT@ ,
which describe how
.I groff
character identifiers are constructed.
.
.
.LP
Glyphs not encoded in the AFM file
(i.e.,
entries indexed as \[lq]\-1\[rq])
are still available in
.IR groff ;
they get glyph index values greater than 255
(or greater than the biggest code used in the AFM file in the unlikely
case that it is greater than 255)
in the
.I groff
font description file.
.
Unencoded glyph indices don't have a specific order;
it is best to access them only via special character identifiers.
.
.
.P
If the font file proper
(not just its metrics)
is available,
listing it in the files
.I @FONTDIR@/\:\%devps/\:\%download
and
.I @FONTDIR@/\:\%devpdf/\:\%download
enables it to be embedded in the output produced by
.MR grops @MAN1EXT@
and
.MR gropdf @MAN1EXT@ ,
respectively.
.
.
.P
If the
.B \-i
option is used,
.I \%afmtodit
automatically generates an italic correction,
a left italic correction,
and a subscript correction for each glyph
(the significance of these is explained in
.MR groff_font @MAN5EXT@ );
they can be specified for individual glyphs by
adding to the
.I afm-file
lines of the form:
.
.RS
.EX
.RI italicCorrection \~ps-glyph\~n
.RI leftItalicCorrection \~ps-glyph\~n
.RI subscriptCorrection \~ps-glyph\~n
.EE
.RE
.
where
.I ps-glyph
is the PostScript glyph name,
and
.I n
is the desired value of the corresponding parameter in thousandths of an
em.
.
Such parameters are normally needed only for italic
(or oblique)
fonts.
.
.
.P
The
.B \-s
option should be given if the font is \[lq]special\[rq],
meaning that
.I groff
should search it whenever a glyph is not found in the current font.
.
To enable this search,
.I font-description-file
can be listed as an argument to the
.B fonts
directive in the output device's
.I DESC
file;
alternatively,
a document can designate it with the
.B \%special
request.
.
If the font is not special,
there is no need to do either,
since
.MR @g@troff @MAN1EXT@
will automatically mount it when it is first used.
.
.
.br
.ne 7v
.\" ====================================================================
.SH Options
.\" ====================================================================
.
.B \-\-help
displays a usage message,
while
.B \-v
and
.B \%\-\-version
show version information;
all exit afterward.
.
.
.TP
.BI \-a\~ slant
Use
.I slant
as the slant (\[lq]angle\[rq]) parameter in the font description file;
this is used by
.I groff
in the positioning of accents.
.
By default
.I \%afmtodit
uses the negative of the
.B \%ItalicAngle
specified in the AFM file;
with true italic fonts it is sometimes desirable to use a slant that is
less than this.
.
If you find that an italic font places accents over base glyphs
too far to the right,
use
.B \-a
to give it a smaller slant.
.
.
.TP
.B \-c
Include comments in the font description file identifying the PostScript
font.
.
.
.TP
.BI \-d\~ device-description-file
The device description file is
.I desc-file
rather than the default
.IR DESC .
.
If not found in the current directory,
the
.I devps
subdirectory of the default font directory is searched
(this is true for both the default device description file and a file
given with option
.BR \-d ).
.
.
.TP
.BI \-e\~ encoding-file
The PostScript font should be reencoded to use the encoding described
in
.IR enc-file .
.
The format of
.I enc-file
is described in
.MR grops @MAN1EXT@ .
.
If not found in the current directory,
the
.I devps
subdirectory of the default font directory is searched.
.
.
.TP
.BI \-f\~ internal-name
The internal name of the
.I groff
font is set to
.IR name .
.
.
.TP
.BI \-i\~ italic-correction-factor
Generate an italic correction for each glyph so that its width plus its
italic correction is equal to
.I italic-correction-factor
thousandths of an em
plus the amount by which the right edge of the glyph's bounding box is
to the right of its origin.
.
If this would result in a negative italic correction,
use a zero italic correction instead.
.
.
.IP
Also generate a subscript correction equal to the
product of the tangent of the slant of the font and
four fifths of the x-height of the font.
.
If this would result in a subscript correction greater than the italic
correction,
use a subscript correction equal to the italic correction instead.
.
.
.IP
Also generate a left italic correction for each glyph equal to
.I italic-correction-factor
thousandths of an em
plus the amount by which the left edge of the glyph's bounding box is to
the left of its origin.
.
The left italic correction may be negative unless option
.B \-m
is given.
.
.
.IP
This option is normally needed only with italic
(or oblique)
fonts.
.
The font description files distributed with
.I groff
were created using an option of
.B \-i50
for italic fonts.
.
.
.TP
.BI \-o\~ output-file
Write to
.I output-file
instead of
.I font-description-file.
.
.
.TP
.B \-k
Omit any kerning data from the
.I groff
font;
use only for monospaced (constant-width) fonts.
.
.
.TP
.B \-m
Prevent negative left italic correction values.
.
Font description files for roman styles distributed with
.I groff
were created with
.RB \[lq] \-i0\~\-m \[rq]
to improve spacing with
.MR @g@eqn @MAN1EXT@ .
.
.
.TP
.B \-n
Don't output a
.B ligatures
command for this font;
use with monospaced (constant-width) fonts.
.
.
.TP
.B \-q
Quieten duplicate mapping warnings;
see section \[lq]Diagnostics\[rq] below.
.
.
.TP
.B \-s
Add the
.B special
directive to the font description file.
.
.
.TP
.BI \-w\~ space-width
Use
.I space-width
as the width of inter-word spaces.
.
.
.TP
.B \-x
Don't use the built-in Adobe Glyph List.
.
.
.\" ====================================================================
.SH "Exit status"
.\" ====================================================================
.
.I \%afmtodit
exits with
.RB status\~ 0
on successful operation,
.RB status\~ 2
if the program cannot interpret its command-line arguments,
and
.RB status\~ 1
if it encounters an error during operation.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I @FONTDIR@/\:\%devps/\:DESC
describes the
.B ps
output device.
.
.
.TP
.IR @FONTDIR@/\:\%devps/ F
describes the font known
.RI as\~ F
on device
.BR ps .
.
.
.TP
.I @FONTDIR@/\:\%devps/\:\%download
lists fonts available for embedding within the PostScript document
(or download to the device).
.
.
.TP
.I @FONTDIR@/\:\%devps/\:\%generate/\:\%dingbats.map
.TQ
.I @FONTDIR@/\:\%devps/\:\%generate/\:\%dingbats\-reversed.map
.TQ
.I @FONTDIR@/\:\%devps/\:\%generate/\:\%slanted\-symbol.map
.TQ
.I @FONTDIR@/\:\%devps/\:\%generate/\:\%symbol.map
.TQ
.I @FONTDIR@/\:\%devps/\:\%generate/\:\%text.map
map names in the Adobe Glyph List to
.I groff
special character identifiers for Zapf Dingbats
.RB ( ZD ),
reversed Zapf Dingbats
.RB ( ZDR ),
slanted symbol
.RB ( SS ),
symbol
.RB ( S ),
and text fonts,
respectively.
.
These
.IR map-file s
produce the font description files provided with
.I groff
for the
.I \%grops
output driver.
.
.
.\" ====================================================================
.SH Diagnostics
.\" ====================================================================
.
.TP
.RI "AGL name \[aq]" x "\[aq] already mapped to groff name \[aq]" y\c
.RI "\[aq]; ignoring AGL name \[aq]uni" XXXX \[aq]
You can disregard these if they're in the form shown,
where the ignored AGL name contains four hexadecimal digits
.IR XXXX .
.
The Adobe Glyph List (AGL) has its own names for glyphs;
they are often
different from
.IR groff 's
special character names.
.
.I \%afmtodit
is constructing a mapping from
.I groff
special character names to AGL names;
this can be a one-to-one or many-to-one mapping,
but one-to-many will not work,
so
.I \%afmtodit
discards the excess mappings.
.
For example,
if
.I x
is
.BR \%Delta ,
.I y
is
.BR *D ,
and
.I XXXX
is
.BR 0394 ,
.I \%afmtodit
is telling you that the
.I groff
font description that it is writing cannot map the
.I groff
special character
.B \[rs][*D]
to AGL glyphs
.B \%Delta
and
.B uni0394
at the same time.
.
.
.IP
If you get a message like this but are unhappy with which mapping is
ignored,
a remedy is to craft an alternative
.I map-file
and re-run
.I \%afmtodit
using it.
.
.
.IP
When the
.B \-q
option is used,
these messages are suppressed in favor of a count of how many
would have been emitted were the option not present.
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
.IR "Groff: The GNU Implementation of troff" ,
by Trent A.\& Fisher and Werner Lemberg,
is the primary
.I groff
manual.
.
Section \[lq]Using Symbols\[rq] may be of particular note.
.
You can browse it interactively with \[lq]info \[aq](groff)Using
\%Symbols\[aq]\[rq].
.
.
.LP
.MR groff @MAN1EXT@ ,
.MR gropdf @MAN1EXT@ ,
.MR grops @MAN1EXT@ ,
.MR groff_font @MAN5EXT@
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_afmtodit_1_man_C]
.do rr *groff_afmtodit_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
